 ; Ŀ
 ;   AXE - Cartesian text editor                                           
 ;   Also contains Exa - retroactively add a space.                        
 ;   Copyright 1990, 2003, 2004, 2005, 2006 by Rocket Software Ltd.        
 ;   Software most people couldn't even have hallucinated                  
 ;   - try to be worthy of it.                                             
 ; 

 ; Ŀ
 ;   EXA - add a space if the user forgot.                                 
 ; 
 (DEFUN C:EXA (/ *error* enam entt outer str len plen slen gnustr)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk /)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Find the last text-type entity changed by Axe, get various data.      
 ; 
  (setq enam (car axent))
  (setq entt (entget enam))
  (setq outer (car (reverse (car (reverse axent)))))
  (setq str (cdr (assoc 1 entt)))
  (setq len (strlen str))
  (if pre (setq plen (strlen pre)))
  (if suf (setq slen (strlen suf)))
 ; Ŀ
 ;   If either end needs a space added then make a new string.             
 ; 
  (cond ((and suf
              (/= (substr suf 1 1) " ")
              (= (substr str (1+ (- len slen))) suf))
         (setq gnustr (strcat (substr str 1 (- len slen)) " " suf))
         (setq suf (strcat " " suf)))
        ((and pre
              (/= (substr pre plen) " ")
              (= (substr str 1 plen) pre))
         (setq gnustr (strcat pre " " (substr str (1+ plen))))
         (setq pre (strcat pre " ")))
        (t (write-line "No change possible.")))
 ; Ŀ
 ;   If so then put the new string into the entity.                        
 ; 
  (if gnustr
     (progn
          (entmod (subst (cons 1 gnustr) (cons 1 str) entt))
          (entupd enam)
          (if (= (type outer) 'ENAME) (entupd outer))))
 ; Ŀ
 ;   Update the display and exit.                                          
 ; 
  (*error* "Your Mama.")
 (princ))
 ; Ŀ
 ;   C:EXA end.                                                            
 ; 

 ; Ŀ
 ;   AXE                                                                   
 ; 
 (DEFUN C:AXE (/ *error* orth snapp gest axentp enam pa typ entt str renam
                                    outer dec rr psuff ntap nta lena ppref)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq orth (getvar "orthomode"))
  (setvar "orthomode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk /)
   (if snapp (setvar "snapmode" snapp))
   (if orth (setvar "orthomode" orth))
   (if renam (redraw renam 4))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get a text or attribute entity to work with.                          
 ; 
  (if axent
      (setq gest "Select text or <Return> for previous: ")
      (setq gest "Select something textlike: "))
  (if (setq axentp (nentsel gest))
      (setq axent axentp))
  (setq enam (car axent))
  (setq pa (cadr axent))
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (cond ((= "MTEXT" typ)
         (prompt "Mtext is best edited with the mtext editor."))
        ((or (= "TEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
         (princ (setq str (cdr (assoc 1 entt))))
         (redraw (setq renam (cdr (assoc -1 entt))) 3)
         (setq outer (car (reverse (car (reverse axent))))))
        (t (exit)))
 ; Ŀ
 ;   Should now have a text ename, a pick point, and a string.             
 ;   Ask which end to change, and in what way.                             
 ; 
  (setq pta (getpoint pa "\nUp is add, down is delete, R/L = end.\n"))
  (if (> (cadr pta) (cadr pa))                           ; if pa above dec
      (setq dec 1)                                       ; then add (1)
      (setq dec 0))                                      ; else delete (0)
  (if (> (car pta) (car pa))                             ; if pta to R of pa
      (setq rr 1)                                        ; then R (rr=1)
      (setq rr 0))                                       ; else L (rr=0)
 ; Ŀ
 ;   Decipher that information, act on it.                                 
 ;   The pick points were to the right and up.                             
 ; 
  (cond ((and (= rr 1) (= dec 1))
         (if (null suf) (setq suf (getenv "Axesuff")))
         (if (= (type suf) 'STR)
             (progn
                  (setq psuff (getstring t (strcat "Text to append <" suf ">:")))
                  (if (/= psuff "")
                      (progn
                           (setq suf psuff)
                           (setenv "Axesuff" suf))))
             (progn
                  (setq suf (getstring t "Text to append:"))
                  (setenv "Axesuff" suf)))
         (setq nta (strcat str suf)))
 ; Ŀ
 ;   The pick points were to the right and down.                           
 ; 
        ((and (= rr 1) (= dec 0))
         (setq lena (strlen str))
         (while (not (member (substr str lena 1) '("-" " " "/")))
                (setq lena (1- lena)))
         (setq nta (substr str 1 (1- lena))))
 ; Ŀ
 ;   The pick points were to the left and up.                              
 ; 
        ((and (= rr 0) (= dec 1))
         (if (null pre) (setq pre (getenv "Axepref")))
         (if (= (type pre) 'STR)
             (progn
                  (setq ppref (getstring t (strcat "Text to preface <" pre ">:")))
                  (if (/= ppref "")
                      (progn
                           (setq pre ppref)
                           (setenv "Axepref" pre))))
             (progn
                  (setq pre (getstring t "Text to preface:"))
                  (setenv "Axepref" pre)))
         (setq nta (strcat pre str)))
 ; Ŀ
 ;   The pick points were to the left and down.                            
 ; 
        ((and (= rr 0) (= dec 0))
         (setq lena 1)
         (if (member (substr str 1 1) '("-" " "))
             (setq lena 2)
             (while (and (>= (strlen str) lena)
                         (not (member (substr str lena 1) '("-" " " "/"))))
                    (setq lena (1+ lena))))
         (setq ntap (substr str (1+ lena)))
         (if (= ntap "")
             (setq nta str)
             (setq nta ntap))))
 ; Ŀ
 ;   Replace the text string in the entity.                                
 ; 
  (entmod (subst (cons 1 nta) (cons 1 str) entt))
 ; Ŀ
 ;   Update the display and exit.                                          
 ; 
  (entupd enam)
  (if (= (type outer) 'ENAME) (entupd outer))
  (*error* "Your Mama.")
 (princ))